// priority: 100
onEvent("recipes", (event) => {
  //Empty Recipe template for when they are disabled on servers
  const emptyRecipe = (item) => {
    event.shapeless(item, Item.of('minecraft:barrier', "{RepairCost:0,display:{Name:'{\"text\":\"Disabled on this server\"}'}}"));
  }

  //Parity with CobbleGenRandomizer
  const customCobbleGen = (below, output) => {
    event.custom({
      "type": "thermal:rock_gen",
      "adjacent": "minecraft:water",
      "below": below,
      "result": {
        "item": output
      }
    });
  }

  customCobbleGen("create:raw_zinc_block", "create:asurine");
  customCobbleGen("minecraft:raw_gold_block", "create:ochrum");
  customCobbleGen("minecraft:raw_copper_block", "create:veridium");
  customCobbleGen("minecraft:raw_iron_block", "create:crimsite");
  customCobbleGen("minecraft:netherite_block", "mysticalagriculture:soulstone_cobble");

  //Corn to seed
  event.shapeless('thermal:corn_seeds', 'thermal:corn');

  //Nuke recipes are disabled through gamemode.json
  if (global.gamemodeFile && global.gamemodeFile.disableNuclearTnt) {
    emptyRecipe('thermal:nuke_tnt');
    emptyRecipe('thermal:nuke_grenade');
    emptyRecipe('thermal:nuke_tnt_minecart');
  } else {
    //Nuke Tnt recipe
    event.shaped('thermal:nuke_tnt', ['RUR', 'ISI', 'RUR'], {
      R: 'solargeneration:solar_core_resonant',
      U: 'solargeneration:solar_core_ultimate',
      I: 'thermal:upgrade_augment_3',
      S: 'mekanism:sps_casing'
    })

    //Nuclear grenade
    event.shapeless('2x thermal:nuke_grenade', ['thermal:nuke_tnt', '#forge:ingots/lumium']);

    //Nuclear Minecart
    event.shaped('thermal:nuke_tnt_minecart', ['T', 'M'], {
      T: 'thermal:nuke_tnt',
      M: 'minecraft:minecart'
    })
  }

  //Allow centrifuging rose quartz back into it's components
  event.recipes.thermal.centrifuge(['minecraft:quartz', '7x minecraft:redstone'], 'create:rose_quartz')

  //Malum node integration. Looks like some generated recipes don't cause Thermal to generate furnace recipes for them, probably mod loading order.
  event.recipes.thermal.furnace('malum:lead_node', 'thermal:lead_nugget')
  event.recipes.thermal.furnace('malum:silver_node', 'thermal:silver_nugget')
  event.recipes.thermal.furnace('malum:aluminum_node', 'immersiveengineering:nugget_aluminum')
  event.recipes.thermal.furnace('malum:nickel_node', 'thermal:nickel_nugget')
  event.recipes.thermal.furnace('malum:uranium_node', 'mekanism:nugget_uranium')
  event.recipes.thermal.furnace('malum:osmium_node', 'mekanism:nugget_osmium')
  event.recipes.thermal.furnace('malum:zinc_node', 'create:zinc_nugget')
  event.recipes.thermal.furnace('malum:tin_node', 'thermal:tin_nugget')
});